﻿/**
 * @fileoverview 
 * adapter for browser api, control browser actions
 * @author sunnyjiang
 * @version 1.1
 */

var browser = {};

/**
 * switch current tab index to browser page id
 * index + 1 = id
 */
browser.getCurrentPageId = function() {
	var currentTab = tabManager.getCurrentTab();
	return tabManager.getPageIdFromTab(currentTab);

};

/**
 * @namespace tabs
 */
browser.tabs = {};
/**
 * remove tab
 */
browser.tabs.remove = function(closeTabIndex) {
	try {
		var pageId = tabManager.getPageIdFromTabIndex(closeTabIndex);
		qqbrowser.tabs.remove(pageId);
	} catch(e) {
	}
};

/**
 * create tab
 * @param fromType 0 skin, 1 address input, 2 bookmark
 * @param search search or not, boolean
 */
browser.tabs.create = function(url, fromType, search) {
	url = url ? url : 'about:blank';
	search = search ? search : 0;
	
	try {
//		var pageId = tabManager.getPageIdFromTabId(tabId);
		qqbrowser.tabs.create(url, fromType, 0, search);
	} catch(e) {
		//add by jingle for debug
		window.open(url);
	}
};

/**
 * 切换tab时
 */
browser.tabs.select = function(tabId) {
//	var index = tabManager.getIndexFromId(tabId);
	var tab = tabManager.getTabFromId(tabId);
	
	if(tab.length != 0) { //  当tab不存在时不调用浏览器api
		try {
			var pageId = tabManager.getPageIdFromTabId(tabId);		

			qqbrowser.tabs.select(pageId);
			
			if (tab.attr("state") === "1") {	//崩溃
				//infobar.setText(infobar.crashText);
				//infobar.showClose(false);
				//infobar.show(true);
				qqbrowser.page.reload(browser.getCurrentPageId());	//直接刷新
			} else if (tab.attr("state") === "2") {	//假死
				infobar.setText(infobar.zombieText);
				infobar.showClose(true);
				window.infobar.refreshButton.show(true);
				window.infobar.show(true);
			} else {
				infobar.show(false);
			}

		} catch(e) {
		}
	}
};


// when drag tabs
//browser.tabs.drag(pageId, index)
browser.tabs.drag = function(pageId, index) {
	try {
		qqbrowser.tabs.drag(pageId, index);
	} catch(e) {
	}
};

/**
 * tabs switch core
 */
browser.tabs.coreSwitch = function() {
	try {
		qqbrowser.tabs.coreSwitch(browser.getCurrentPageId());
	} catch(e) {
	}
};

//qqbrowser.tabs.home(0)
browser.tabs.home = function() {
	try {
		qqbrowser.tabs.home(0);
	} catch(e) {
	}
};

/**
 * @namespace page actions
 */
browser.page = {};
/**
 * page go back
 */
browser.page.goBack = function() {
	try {
		qqbrowser.page.goBack(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page go forward
 */
browser.page.goForward = function() {
	try {
		qqbrowser.page.goForward(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page reload
 */
browser.page.reload = function() {
	try {	
		qqbrowser.page.reload(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page stop load
 */
browser.page.stopLoad = function() {
	try {		
		qqbrowser.page.stopLoad(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page open link
 */
browser.page.navigate = function(url) {
	try {		
		qqbrowser.page.navigate(browser.getCurrentPageId(), url, 0);
	} catch(e) {
	}
};

/**
 * @namespace window actions
 */
browser.window = {};
/**
 * page 浏览器最小化
 */
browser.window.minimize = function() {
	try {
		qqbrowser.window.minimize();
	} catch(e) {
	}
};

/**
 * page 浏览器最大化
 */
browser.window.maximize = function() {
	try {
		qqbrowser.window.maximize();
	} catch(e) {
	}
};

/**
 * page 关闭浏览器
 */
browser.window.close = function() {
	try {
		qqbrowser.window.close();
	} catch(e) {
	}
};

// 获取当前windowid
//qqbrowser.window.currentId()
browser.window.currentId = function() {
	try {
		return qqbrowser.window.currentId();
	} catch(e) {
	}
};


/**
 * @namespace skin actions
 */
browser.skin = {};

/**
 * @namespace menu actions
 */
browser.skin.menu = {};

browser.skin.menu.build = function(envId, type, params) {
	var menuMap = {mainMenu: 1, logoMenu: 2, contentMenu: 3, tabMenu: 4, toolbarMenu: 5, 
			addressbarMenu: 6, favbarMenu: 7, usefulMenu: 8, 
			logonMenu: 9, usefulSubMenu: 10, tabSubMenu: 11, addressbarBlankMenu: 6, recentCloseMenu: 18, titleBarMenu: 19 ,
	        favFolderMenu:20 , favCtxMenu:21, sidebarMenu:22};
	
	var typeId = /\d+/.test(menuMap[type]) ? menuMap[type] : type; // 如果map里没有，为子菜单id，直接传递
	
	var menuParams = {};
	menuParams = params.contentParams 
		? params.contentParams // 右键菜单需要的参数
		: { // 浏览器根据此识别处理收藏夹右键菜单
			'favId': params.favId ? params.favId : 0, // 收藏夹fav id
			'favType': params.favType ? params.favType : 'favbar', // 收藏夹favType
			'rootId': params.rootId,
			'inputText': params.inputText ? params.inputText : '', // 地址栏选中的文字,		//added by lucaszhong 2011/3/6
			'pageId': params.pageId ? params.pageId : 0, // 标签页右键判断左右标签页是否存在 added by lucaszhong 2011/3/8
			'addressInput': params.addressInput ? params.addressInput :	false // 地址栏是否有输入	
	};	
//	alert("type: "+type+"(in menu build)");	
//	alert("id: "+typeId);
//	alert(JSON.stringify(menuParams));
	menuParams.bookmarkState = window.bookmarkState || 0;
	try{
		qqbrowser.log.info("typeId: "+typeId);
		qqbrowser.skin.menu.build(envId, typeId, menuParams, function(menuData) {
			qqbrowser.log.info("in browser skin menu build cb: menuData "+menuData);
			browser.skin.menu.popup(envId, type, params, menuData);
		});
	}catch(err){
	}

};

/**
 * 调用浏览器API，此时需要创建一个右键菜单
 * @param params.type 菜单类型，此参数浏览器会传递给menu页面
 * @param params.tabId 如果是tabMenu，会附带tabId，需要将此参数再传给menu页面，以便对该tab进行操作
 * @param params.parentId 父菜单的Id，如果是顶级菜单，此项为-1
 * @param params.contentParams 页面右键菜单需要的参数，直接传给浏览器
 * @param params.location 菜单出现的坐标
 */
browser.skin.menu.popup = function(envId, type, params, menuData) {

	try {
		var menuMap = {mainMenu: 1, logoMenu: 2, contentMenu: 3, tabMenu: 4, toolbarMenu: 5, 
			addressbarMenu: 6, favbarMenu: 7, usefulMenu: 8, 
			logonMenu: 9, usefulSubMenu: 10, tabSubMenu: 11, addressbarBlankMenu: 6, recentCloseMenu: 18, titleBarMenu: 19 ,
	        favFolderMenu:20 , favCtxMenu:21, sidebarMenu:22};
		var menuParams = {};
		menuParams.nParentId = params.parentId ? params.parentId : 0; // 没有parentId是最上层菜单，为-1
		menuParams.nTypeId = /\d+/.test(menuMap[type]) ? menuMap[type] : type; // 如果map里没有，为子菜单id，直接传递

		// TODO 根据配置设置路径
		if(type == 'logoMenu') { // 点击头像且未登录时
			menuParams.strUrl = 'aero/beforeLoginMenu.html';	
		} else if(type == 'logonMenu') { // 点击头像且登录时
			menuParams.strUrl = 'aero/afterLoginMenu.html';		
//		} else if(type == 'addressbarMenu' || type == 'addressbarBlankMenu') { // 地址栏右键菜单
//			menuParams.strUrl = 'aero/addressMenu.html';	
		} else if('favFolderMenu' == type){
			menuParams.strUrl = 'aero/favFolderMenu.html';
		} else if('favCtxMenu' == type){
			menuParams.strUrl = 'aero/favCtxMenu.html';
		}else if ('sidebarMenu' == type){
			menuParams.strUrl = 'aero/sidebarMenu.html';
		}else{ // 菜单
			menuParams.strUrl = 'aero/menu.html';
		}
		
		menuParams.leftBottomX = params.location.leftBottomX;
		menuParams.leftBottomY = params.location.leftBottomY;
		menuParams.rightTopY = params.location.rightTopY;
		menuParams.rightTopX = params.location.rightTopX;		
	//	alert(params.folderID);
		menuParams.returnParams = { // 将传递给菜单页面的参数
			'tabId': params.tabId ? params.tabId : 0, // 选中了那个tab，用于tab右键菜单
			'isTextSelected': type == 'addressbarMenu' ? 1 : 0 // 是否选中了文字，用于地址栏右键菜单 
		};
/*		menuParams.params = { // 浏览器根据此识别处理收藏夹右键菜单
			'favId': params.favId ? params.favId : 0, // 收藏夹fav id
			'favType': params.favType ? params.favType : 'favbar', // 收藏夹favType
		}*/
		//alert("root id in popup:"+params.rootId);
		menuParams.params = params.contentParams 
			? params.contentParams // 右键菜单需要的参数
			: { // 浏览器根据此识别处理收藏夹右键菜单
				'pageId': params.pageId ? params.pageId : 0,
				'favId': params.favId ? params.favId : 0, // 收藏夹fav id
				'rootId':params.rootId,
				'favType': params.favType ? params.favType : 'favbar', // 收藏夹favType,
				'inputText': params.inputText ? params.inputText : '', // 收藏夹favType,						
				'url':params.url?params.url:'',
				'title':params.title?params.title:''
			};
		if ('favFolderMenu' == type){
			// 收藏栏 传参
			menuParams.params.folderID = params.folderID;
			menuParams.params.startID = params.startID?  params.startID :0;
		}
		menuParams.menuData = eval('(' + menuData + ')');
		
		var menuElementMap = {
			mainMenu: "menu-button",
			logoMenu: undefined,
			contentMenu: undefined, 
			tabMenu: undefined, 
			toolbarMenu: undefined, 
			addressbarMenu: undefined, 
			favbarMenu: undefined, 
			usefulMenu: "useful-menu-button", 
			logonMenu: undefined, 
			usefulSubMenu: undefined, 
			tabSubMenu: undefined, 
			addressbarBlankMenu: undefined, 
			recentCloseMenu: "undo-list-button", 
			titleBarMenu: undefined,
	        favFolderMenu: undefined, 
	        favCtxMenu:undefined
		};
		var menuElementName = menuElementMap[type];
		var menuElement = $("#" + menuElementName);
		
		menuParams.onCreate = function(json) {
			if (undefined !== menuElement) {
				menuElement.addClass(menuElementName + "-pressed");
				menuElement.removeClass(menuElementName);
			}
		};
		
		// 此function是菜单隐藏时调用的，需根据此设置标志，然后再点击时决定是否显示菜单
		menuParams.onDestroy = function(json) {
			if (undefined !== menuElement) {				
				menuElement.addClass(menuElementName);
				menuElement.removeClass(menuElementName + "-pressed");
			}
		};
		
		menuParams.envId = envId;
		
		try{
			qqbrowser.log.info("will popup menu");
			qqbrowser.log.info("folderID: "+menuParams.params.folderID);
			// debug into
			qqbrowser.skin.menu.popup(menuParams);
		}catch(err){
		}
	} catch(e) {
		// do nothing
		//alert(e.name + e.message);
	}	
};

/**
 * menu页面初始化，从浏览器API获取所需的数据
 * @param menuId 浏览器生成的唯一Id，调用menu页面时作为参数传递进页面
 */
browser.skin.menu.init = function(menuId) {
	try {
		qqbrowser.skin.menu.init(menuId, function(menuData) {
			// 空时调一个默认的菜单
            qqbrowser.log.info("menuData: "+menuData);				
			if(menuData == '') {
				return menu.build({});
			}

			// 将传过来的json string转换为object
			menuData = eval('(' + menuData + ')'); 
			
			// 根据取得的菜单项数组构造菜, 返回宽和高
			return menu.build(menuData);
		});
	} catch(e) {
		// do nothing
		//alert(e.name + e.message);
	}
};

/**
 * 点击菜单项发生的事件
 * @param menuId 菜单的Id
 * @param itemId 菜单项的Id
 */
browser.skin.menu.click = function(menuId, itemId) {
	try {
		qqbrowser.skin.menu.click(menuId, itemId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 隐藏子菜单
browser.skin.menu.hideSubMenu = function(parentId) {
	qqbrowser.skin.menu.hideSubMenu(parentId);
};

//qqbrowser.skin.resize
browser.skin.resize = function(positionInfo) {
	try {
		qqbrowser.skin.resize(positionInfo);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

//qqbrowser.skin.dragStart
browser.skin.dragStart = function(type) {
	try {
		qqbrowser.skin.dragStart(type);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}	
};

/**
 * @namespace skin addressbar actions
 */
browser.skin.addressbar = {};

// 下拉条/triggerInputBegin时
//qqbrowser.skin.addressbar.pop(nX, nY, nWidth, nHeight);
browser.skin.addressbar.pop = function(nX, nY, nWidth, nHeight) {
	try {
		qqbrowser.skin.addressbar.pop(nX, nY, nWidth, nHeight);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 焦点到地址栏输入第一个之后发送
//qqbrowser.skin.addressbar.triggerInputBegin();
browser.skin.addressbar.triggerInputBegin = function() {

	try {
		qqbrowser.skin.addressbar.triggerInputBegin();
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 每次输入发送
//qqbrowser.skin.addressbar.triggerInputChange(text)
browser.skin.addressbar.triggerInputChange = function(text, inputId) {

	try {
		qqbrowser.skin.addressbar.triggerInputChange(text, inputId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 输入完成点回车或者转到
//qqbrowser.skin.addressbar.triggerInputAccept(text)
browser.skin.addressbar.triggerInputAccept = function(text) {
	try {
		qqbrowser.skin.addressbar.triggerInputAccept(text);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

//页面调用，获取id和数据
//qqbrowser.skin.addressbar.init(func);
browser.skin.addressbar.init = function(func1, func2) { 
	try {
		qqbrowser.skin.addressbar.init(func1, func2);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 创建完毕后发送height，为0 hide
//qqbrowser.skin.addressbar.adjustHeight
browser.skin.addressbar.adjustHeight = function(addressListheight) {
	try {
		qqbrowser.skin.addressbar.adjustHeight(addressListheight);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

// 删除一项
browser.skin.addressbar.deleteResult = function(extId, itemId) {
	try {
		qqbrowser.skin.addressbar.deleteResult(extId, itemId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

//skin.addressbar.triggerDroplistShowByClick
browser.skin.addressbar.triggerDroplistShowByClick = function() {
	try {
		qqbrowser.skin.addressbar.triggerDroplistShowByClick();
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
};

//qqbrowser.skin.tab.triggerDragOut(tabId);
browser.skin.tab = {};
browser.skin.tab.triggerDragOut = function(tabId) {
	try {
		qqbrowser.skin.tab.triggerDragOut(tabId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}	
};

// qqbrowser.skin.buttonClicked(strExtId)
/**
 * 点击按钮时的动作
 */
browser.skin.buttonClicked = function(strExtId, button, clickType) {
	var buttonLeftBottom = view.getMenuLeftBottom($(button));

/*	var statusbarButtonFixedHeight = $(button).height() / 2 * (-1) - 1;
	// statusbar button fix
	if(button.id == "zoom-drop-button") {
//		buttonLeftBottom.left += 6;
		buttonLeftBottom.top += statusbarButtonFixedHeight;
	}
	else if(button.id == "screen-box") {
//		buttonLeftBottom.left += 20;
		buttonLeftBottom.top += statusbarButtonFixedHeight;
	}*/

	clickType = clickType ? clickType : 1; // 浏览器需要的点击类型，1为button，2为下拉列表

//	alert([buttonLeftBottom.left, buttonLeftBottom.top]);
	try {
		qqbrowser.skin.buttonClicked(strExtId, buttonLeftBottom.left, buttonLeftBottom.top, clickType);
	} catch(e) {
	}
};


// 返回最小宽高
browser.skin.setMinSize = function() {
	try {
		var minSize = layout.getMinSize();
		qqbrowser.skin.setMinSize(minSize.width, minSize.height);
	} catch(e) {
		// do nothing
	//	alert(e.message);
	}
};

browser.skin.window = {};
// 焦点管理
// qqbrowser.skin.window.setFocus(windowId);
// 设置焦点到网页上
browser.skin.window.setFocus = function() {
	var windowId = browser.window.currentId();
	qqbrowser.skin.window.setFocus(windowId);
};

// qqbrowser.skin.window.setFocusToWeb(windowId);
// 设置焦点到page上
browser.skin.window.setFocusToWeb = function() {
	var windowId = browser.window.currentId();
	try {
		qqbrowser.skin.window.setFocusToWeb(windowId);
	} catch(e) {	
	}
};

browser.os = {};
browser.os.windows = {};
//qqbrowser.os.windows.isDwmCompositionEnabled
browser.os.windows.isDwmCompositionEnabled = function() {
	try {
		return qqbrowser.os.windows.isDwmCompositionEnabled();
	} catch(e) {
		return 0;
		// do nothing
//		alert(e.message);
	}
};

browser.popup = {};
browser.popup.create = function() {
	var menuLeft = 0;
	var menuTop = 0;
	// 主菜单和常用菜单单独处理
	// TODO ?
	var button = $('#fav-button');
	menuLeft = button.offset().left - 100;
	menuTop = button.offset().top + button.height() + 4;	
	qqbrowser.popup.create(menuLeft, menuTop);
};

//account.getCurrent(fun) fun(obj)obj.nUin strNickName strFacePath strUin 
browser.account = {};
browser.account.getCurrent = function(func) {
	try {	
		qqbrowser.account.getCurrent(func);
	} catch(e) {
	}	
};

//recentclosed.undo
browser.recentclosed = {};
browser.recentclosed.undo = function() {
	try {
		qqbrowser.recentclosed.undo();
	} catch(e) {
	}
};

browser.recentclosed.get = function(func) {
	try {
		qqbrowser.recentclosed.get(func);
	} catch(e) {
	}
};

browser.tooltip = {};
browser.tooltip.create = function(popRect, trackRect, params, func) {
	try {
		var windowId = browser.window.currentId();

		return qqbrowser.tooltip.create(windowId, popRect, trackRect, params, func);
	} catch(e) {
	}	
};

browser.tooltip.destroy = function(tooltipId) {
	try {
		qqbrowser.tooltip.destroy(tooltipId);
	} catch(e) {
	}	
};

browser.dialog = {};
browser.dialog.resize = function(x, y, width, height) {
	try {
		qqbrowser.dialog.resize(x, y, width, height);		
	} catch(e) {		
	}
};

browser.extension = {};
browser.extension.builtin = {}; 
browser.extension.builtin.config = {};
browser.extension.builtin.config.get = function(request, callback) {
	try
	{
		qqbrowser.extension.builtin.config.get(request, callback);
	}
	catch (e)
	{
	}
};

browser.extension.builtin.config.set = function(config, callback) {
	try
	{
		qqbrowser.extension.builtin.config.set(config, callback);
	}
	catch (e)
	{
	}
};


/**
 * 判断当前是页面还是浏览器环境
 */
browser.isPage = function() {
	try {
		var isPage = qqbrowser;
		return 0;
	} catch(e) {
		return 1;
	}
};

/**
 * 和皮肤有关的数据上报
 */
browser.extension.builtin.statistics = {};
browser.extension.builtin.statistics.increase = function(id) {
	try 
	{
		qqbrowser.extension.builtin.statistics.increase(id);
	} 
	catch(e) 
	{
		
	}
};
